<?php

include 'connection.php';

// Get data from POST request
$devicename = isset($_POST['devicename']) ? $_POST['devicename'] : '';
$locationstatus = isset($_POST['locationstatus']) ? $_POST['locationstatus'] : '';

// Check if devicename is empty
if (empty($devicename)) {
    echo "Error: Device name is required.";
} else {
    // Update the specified column value based on device name
    $sql_update = "UPDATE user SET locationstatus = :locationstatus WHERE devicename = :devicename";
    $stmt_update = $conn->prepare($sql_update);
    $stmt_update->bindParam(':locationstatus', $locationstatus);
    $stmt_update->bindParam(':devicename', $devicename);

    if ($stmt_update->execute()) {
        echo "Lock status updated";
    } else {
        echo "Error: " . $stmt_update->errorInfo()[2];
    }
}

?>
